<?php
// Database connection settings
$host = "localhost";
$dbname = "login_db"; // Change this to login_db
$username = "root";   // Replace with your database username if different
$password = "";       // Replace with your database password if set

// Connect to login_db database
$mysqli = new mysqli($host, $username, $password, $dbname);

// Check for connection errors
if ($mysqli->connect_error) {
    die("Connection failed: " . $mysqli->connect_error);
}

// Check if the form was submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $artistName = $_POST['artistName'];
    $description = $_POST['description'];
    $profileImage = $_FILES['profileImage'];

    // Ensure the uploads directory exists
    $targetDir = "../uploads/"; // Adjust path if necessary
    if (!is_dir($targetDir)) {
        mkdir($targetDir, 0777, true); // Create the directory if it doesn't exist
    }

    // Handle the image upload
    if ($profileImage['error'] == UPLOAD_ERR_OK) {
        $targetFile = $targetDir . basename($profileImage['name']);
        echo $targetFile;
        // Move the uploaded file to the target directory
        if (move_uploaded_file($profileImage['tmp_name'], $targetFile)) {
            // Image upload successful, store the path in the database
            $imagePath = $targetFile;

            // Prepare and execute the SQL insert statement
            $stmt = $mysqli->prepare("INSERT INTO artists (artist_name, description, image_path) VALUES (?, ?, ?)");
            $stmt->bind_param("sss", $artistName, $description, $imagePath);

            if ($stmt->execute()) {
                header('Location: ../ArtistsPage.php');
            } else {
                echo "Error: " . $stmt->error;
            }

            $stmt->close();
        } else {
            echo "Failed to upload the image.";
        }
    } else {
        echo "Image upload error: " . $profileImage['error'];
    }
}

// Close the database connection
$mysqli->close();
?>
